//
//  Studies.swift
//  OnlineBanking
//
//  Created by Marvin Kowalewski on 14.02.23.
//

import UIKit

extension UIImage {
    func convertToGrayScale() -> UIImage? {
        let colorSpace = CGColorSpaceCreateDeviceGray()
        let bitmapInfo = CGBitmapInfo(rawValue: CGImageAlphaInfo.none.rawValue)

        guard let context = CGContext(data: nil,
                                      width: Int(size.width),
                                      height: Int(size.height),
                                      bitsPerComponent: 8,
                                      bytesPerRow: 0,
                                      space: colorSpace,
                                      bitmapInfo: bitmapInfo.rawValue) else {
            return nil
        }

        let rect = CGRect(x: 0, y: 0, width: size.width, height: size.height)
        context.draw(cgImage!, in: rect)

        guard let grayscaleImage = context.makeImage() else {
            return nil
        }

        return UIImage(cgImage: grayscaleImage)
    }
}

struct Study {
    let title: String
    let image: UIImage
}

let studies: [Study] = [
    Study(title: "Smartphone Nutzung", image: UIImage(named: "SmartphoneUsage_ScreenStats")!),
    Study(title: "Light Banking (Online Banking)", image: UIImage(named: "LightBanking_icon")!), //Study(title: "Online Banking", image: UIImage(named: "IconGradientLogo")!), // Online Banking
    Study(title: "Smartphone vs Computer", image: UIImage(named: "SmartphoneVSComputer_DeviceDuel")!),
    Study(title: "Instant Messenger", image: UIImage(named: "IconGradient_Other_instage")!.convertToGrayScale()!),
    Study(title: "3D Navigation", image: UIImage(named: "IconGradient_Other_navigation")!.convertToGrayScale()!),
    Study(title: "Handabdruck Scanner", image: UIImage(named: "IconGradient_Other_scanner")!.convertToGrayScale()!),
    Study(title: "Check Your Tasks", image: UIImage(named: "IconGradient_Other_CheckApp")!.convertToGrayScale()!)
]
